unit APIMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Winspool, AVPAPI;

type
  TAPIForm = class(TForm)
    SetVPBtn: TButton;
    PortName: TEdit;
    Application: TEdit;
    DirectToFile: TEdit;
    DragDrop: TEdit;
    Extension: TEdit;
    FileHandling: TEdit;
    Forwarding: TEdit;
    LogName: TEdit;
    LogOptions: TEdit;
    NameOptions: TEdit;
    Port: TEdit;
    ShowWindow: TEdit;
    UserDir: TEdit;
    Spooling: TEdit;
    UserName: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Password: TEdit;
    Domain: TEdit;
    ExitBtn: TButton;
    GetVPBtn: TButton;
    SetVPPathlBtn: TButton;
    Memo1: TMemo;
    PortList: TComboBox;
    Label18: TLabel;
    AppWaitOptions: TEdit;
    AppWaitTimeout: TEdit;
    AppWaitDelete: TEdit;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label19: TLabel;
    TCPPort: TEdit;
    Label23: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    Label33: TLabel;
    Label34: TLabel;
    Label35: TLabel;
    Label36: TLabel;
    TcpBindings: TEdit;
    TcpOptions: TEdit;
    Enabled: TEdit;
    SnmpEnabled: TEdit;
    SnmpManufacturer: TEdit;
    SnmpHardwareId: TEdit;
    SnmpModel: TEdit;
    SnmpOptions: TEdit;
    DebugOptions: TEdit;
    TimeOptions: TEdit;
    Modified: TEdit;
    ModifiedBy: TEdit;
    ModifiedPreviously: TEdit;
    ModifiedPreviouslyBy: TEdit;
    Memo2: TMemo;
    procedure SetVPBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ExitBtnClick(Sender: TObject);
    procedure GetVPBtnClick(Sender: TObject);
    procedure SetVPPathlBtnClick(Sender: TObject);
    procedure PortListChange(Sender: TObject);
  private
    { Private declarations }
    Procedure LoadPortList;
  public
    { Public declarations }
  end;

var
  APIForm: TAPIForm;

implementation


{$R *.DFM}


procedure TAPIForm.SetVPBtnClick(Sender: TObject);
Var
  H : THandle;
  F : TSetVirtualPortProc;
  P : TVirtualPortV6;

begin
  F := Nil;
  H := LoadLibrary(VPAPIDLL);
  If H <> 0 Then
  Begin
    F := GetProcAddress(H,'SetVirtualPort');
  End;
  If Assigned(F) Then
  Begin
    FillChar(P,SizeOf(P),0);
    P.Size := SizeOf(TVirtualPortV6);
    P.hWnd := 0; // No longer used
    P.PortName := StrNew(PChar(PortName.Text));
    P.Application := StrNew(PChar(Application.Text));
    P.DirectToFile := StrNew(PChar(DirectToFile.Text));
    P.DragDrop := StrNew(PChar(DragDrop.Text));
    P.Extension := StrNew(PChar(Extension.Text));
    P.FileHandling := StrNew(PChar(FileHandling.Text));
    P.Forwarding := StrNew(PChar(Forwarding.Text));
    P.LogName := StrNew(PChar(LogName.Text));
    P.LogOptions := StrNew(PChar(LogOptions.Text));
    P.NameOptions := StrNew(PChar(NameOptions.Text));
    P.Port := StrNew(PChar(Port.Text));
    P.ShowWindow := StrNew(PChar(ShowWindow.Text));
    P.UserDir := StrNew(PChar(UserDir.Text));
    P.Spooling := StrNew(PChar(Spooling.Text));
    P.UserName := StrNew(PChar(UserName.Text));
    P.Password := StrNew(PChar(Password.Text));
    P.Domain := StrNew(PChar(Domain.Text));
    P.AppWaitOptions := StrNew(PChar(AppWaitOptions.Text));
    P.AppWaitTimeout := StrNew(PChar(AppWaitTimeout.Text));
    P.AppWaitDelete := StrNew(PChar(AppWaitDelete.Text));
    // V6 Options
    P.TCPPort := StrNew(PChar(TCPPort.Text));
    P.TCPBindings := StrNew(PChar(TCPBindings.Text));
    P.TCPOptions := StrNew(PChar(TCPOptions.Text));
    P.Enabled := StrNew(PChar(Enabled.Text));
    P.SnmpEnabled := StrNew(PChar(SnmpEnabled.Text));
    P.SnmpManufacturer := StrNew(PChar(SnmpManufacturer.Text));
    P.SnmpHardwareId := StrNew(PChar(SnmpHardwareId.Text));
    P.SnmpModel := StrNew(PChar(SnmpModel.Text));
    P.SnmpOptions := StrNew(PChar(SnmpOptions.Text));
    P.DebugOptions := StrNew(PChar(DebugOptions.Text));
    P.TimeOptions := StrNew(PChar(TimeOptions.Text));
    P.Modified := StrNew(PChar(Modified.Text));
    P.ModifiedBy := StrNew(PChar(ModifiedBy.Text));
    P.ModifiedPreviously := StrNew(PChar(ModifiedPreviously.Text));
    P.ModifiedPreviouslyBy := StrNew(PChar(ModifiedPreviouslyBy.Text));

    If Not F(@P) Then
    Begin
      MessageDlg('SetVirtualPort() failed. ' + SysErrorMessage(GetLastError),mtError,[mbOK],0);
    End Else
    Begin
      MessageBeep(MB_ICONEXCLAMATION);
    End;
    FreeLibrary(H);
    StrDispose(P.PortName);
    StrDispose(P.Application);
    StrDispose(P.DirectToFile);
    StrDispose(P.DragDrop);
    StrDispose(P.Extension);
    StrDispose(P.FileHandling);
    StrDispose(P.Forwarding);
    StrDispose(P.LogName);
    StrDispose(P.LogOptions);
    StrDispose(P.NameOptions);
    StrDispose(P.Port);
    StrDispose(P.ShowWindow);
    StrDispose(P.UserDir);
    StrDispose(P.Spooling);
    StrDispose(P.UserName);
    StrDispose(P.Password);
    StrDispose(P.Domain);

    StrDispose(P.AppWaitOptions);
    StrDispose(P.AppWaitTimeout);
    StrDispose(P.AppWaitDelete);

    StrDispose(P.TCPPort);
    StrDispose(P.TCPBindings);
    StrDispose(P.TCPOptions);
    StrDispose(P.Enabled);
    StrDispose(P.SnmpEnabled);
    StrDispose(P.SnmpManufacturer);
    StrDispose(P.SnmpHardwareId);
    StrDispose(P.SnmpModel);
    StrDispose(P.SnmpOptions);
    StrDispose(P.DebugOptions);
    StrDispose(P.TimeOptions);
    StrDispose(P.Modified);
    StrDispose(P.ModifiedBy);
    StrDispose(P.ModifiedPreviously);
    StrDispose(P.ModifiedPreviouslyBy);

  End Else
  Begin
    MessageDlg('LoadLibrary() failed. ' + SysErrorMessage(GetLastError) + sLineBreak + 'Make sure the platform bitness is correct.',mtError,[mbOK],0);
  End;
end;

Procedure TAPIForm.LoadPortList;
Var
  I : Cardinal;
  N : Cardinal;
  R : Cardinal;
  P : PPortInfo2;
  M : PPortInfo2;
begin
  P := Nil;
  N := 0;
  R := 0;
  EnumPorts(Nil,2,P,0,N,R);
  If GetLastError = ERROR_INSUFFICIENT_BUFFER Then
  Begin
    GetMem(M,N);
    P := M;
    If EnumPorts(Nil,2,P,N,N,R) Then
    Begin
      For I := 0 to R - 1 Do
      Begin
        If StrComp(P^.pMonitorName,'Alphatronics Virtual Port') = 0 Then
        Begin
          PortList.Items.Add(StrPas(P^.pPortName));
        End;
        Inc(P);
      End;
      FreeMem(M);
      PortList.ItemIndex := 0;
    End;
  End;
End;

procedure TAPIForm.FormCreate(Sender: TObject);
begin
  LoadPortList;
  If PortList.Items.Count > 0 Then
  Begin
    PortName.Text := PortList.Text;
    Try
      GetVPBtnClick(Self);
    Except
      // Nothing
    End;
  End;
end;

procedure TAPIForm.ExitBtnClick(Sender: TObject);
begin
  Close;
end;

procedure TAPIForm.GetVPBtnClick(Sender: TObject);
Const
  BufferSize = 2048;
Var
  H : THandle;
  F : TGetVirtualPortProc;
  P : TVirtualPortV6;

begin
  F := Nil;
  H := LoadLibrary(VPAPIDLL);
  If H <> 0 Then
  Begin
    F := GetProcAddress(H,'GetVirtualPort');
  End;
  If Assigned(F) Then
  Begin
    FillChar(P,SizeOf(P),0);
    P.Size := SizeOf(TVirtualPortV6);
    P.PortName := StrAlloc(BufferSize);
    StrPCopy(P.PortName,PortName.Text);
    P.Application := StrAlloc(BufferSize);
    P.DirectToFile := StrAlloc(BufferSize);
    P.DragDrop := StrAlloc(BufferSize);
    P.Extension := StrAlloc(BufferSize);
    P.FileHandling := StrAlloc(BufferSize);
    P.Forwarding := StrAlloc(BufferSize);
    P.LogName := StrAlloc(BufferSize);
    P.LogOptions := StrAlloc(BufferSize);
    P.NameOptions := StrAlloc(BufferSize);
    P.Port := StrAlloc(BufferSize);
    P.ShowWindow := StrAlloc(BufferSize);
    P.UserDir := StrAlloc(BufferSize);
    P.Spooling := StrAlloc(BufferSize);
    P.UserName := StrAlloc(BufferSize);
    P.Password := StrAlloc(BufferSize);
    P.Domain := StrAlloc(BufferSize);
    P.AppWaitOptions := StrAlloc(BufferSize);
    P.AppWaitTimeout := StrAlloc(BufferSize);
    P.AppWaitDelete := StrAlloc(BufferSize);

    P.TCPPort := StrAlloc(BufferSize);
    P.TCPBindings := StrAlloc(BufferSize);
    P.TCPOptions := StrAlloc(BufferSize);
    P.Enabled := StrAlloc(BufferSize);
    P.SnmpEnabled := StrAlloc(BufferSize);
    P.SnmpManufacturer := StrAlloc(BufferSize);
    P.SnmpHardwareId := StrAlloc(BufferSize);
    P.SnmpModel := StrAlloc(BufferSize);
    P.SnmpOptions := StrAlloc(BufferSize);
    P.DebugOptions := StrAlloc(BufferSize);
    P.TimeOptions := StrAlloc(BufferSize);
    P.Modified := StrAlloc(BufferSize);
    P.ModifiedBy := StrAlloc(BufferSize);
    P.ModifiedPreviously := StrAlloc(BufferSize);
    P.ModifiedPreviouslyBy := StrAlloc(BufferSize);


    If Not F(@P,BufferSize) Then
    Begin
      MessageDlg('GetVirtualPort failed. ' + SysErrorMessage(GetLastError) + sLineBreak + 'Make sure the platform bitness is correct.',mtError,[mbOK],0);
    End Else
    Begin
      PortName.Text := P.PortName;
      Application.Text := P.Application;
      DirectToFile.Text := P.DirectToFile;
      DragDrop.Text := P.DragDrop;
      Extension.Text := P.Extension;
      FileHandling.Text := P.FileHandling;
      Forwarding.Text := P.Forwarding;
      LogName.Text := P.LogName;
      LogOptions.Text := P.LogOptions;
      NameOptions.Text := P.NameOptions;
      Port.Text := P.Port;
      ShowWindow.Text := P.ShowWindow;
      UserDir.Text := P.UserDir;
      Spooling.Text := P.Spooling;
      UserName.Text := P.UserName;
      Password.Text := P.Password;
      Domain.Text := P.Domain;
      AppWaitOptions.Text := P.AppWaitOptions;
      AppWaittimeout.Text := P.AppWaitTimeout;
      AppWaitDelete.Text := P.AppWaitDelete;

      TCPPort.Text := P.TCPPort;
      TCPBindings.Text := P.TCPBindings;
      TCPOptions.Text := P.TCPOptions;
      Enabled.Text := P.Enabled;
      SnmpEnabled.Text := P.SnmpEnabled;
      SnmpManufacturer.Text := P.SnmpManufacturer;
      SnmpHardwareId.Text := P.SnmpHardwareId;
      SnmpModel.Text := P.SnmpModel;
      SnmpOptions.Text := P.SnmpOptions;
      DebugOptions.Text := P.DebugOptions;
      TimeOptions.Text := P.TimeOptions;
      Modified.Text := P.Modified;
      ModifiedBy.Text := P.ModifiedBy;
      ModifiedPreviously.Text := P.ModifiedPreviously;
      ModifiedPreviouslyBy.Text := P.ModifiedPreviouslyBy;

    End;
    FreeLibrary(H);
    StrDispose(P.PortName);
    StrDispose(P.Application);
    StrDispose(P.DirectToFile);
    StrDispose(P.DragDrop);
    StrDispose(P.Extension);
    StrDispose(P.FileHandling);
    StrDispose(P.Forwarding);
    StrDispose(P.LogName);
    StrDispose(P.LogOptions);
    StrDispose(P.NameOptions);
    StrDispose(P.Port);
    StrDispose(P.ShowWindow);
    StrDispose(P.UserDir);
    StrDispose(P.Spooling);
    StrDispose(P.UserName);
    StrDispose(P.Password);
    StrDispose(P.Domain);
    StrDispose(P.AppWaitOptions);
    StrDispose(P.AppWaitTimeout);
    StrDispose(P.AppWaitDelete);

    StrDispose(P.TCPPort);
    StrDispose(P.TCPBindings);
    StrDispose(P.TCPOptions);
    StrDispose(P.Enabled);
    StrDispose(P.SnmpEnabled);
    StrDispose(P.SnmpManufacturer);
    StrDispose(P.SnmpHardwareId);
    StrDispose(P.SnmpModel);
    StrDispose(P.SnmpOptions);
    StrDispose(P.DebugOptions);
    StrDispose(P.TimeOptions);
    StrDispose(P.Modified);
    StrDispose(P.ModifiedBy);
    StrDispose(P.ModifiedPreviously);
    StrDispose(P.ModifiedPreviouslyBy);

  End Else
  Begin
    MessageDlg(SysErrorMessage(GetLastError) + sLineBreak + 'Make sure the platform bitness is correct.',mtError,[mbOK],0);
  End;
end;

procedure TAPIForm.SetVPPathlBtnClick(Sender: TObject);
Var
  H : THandle;
  F : TSetVirtualPortProc;
  P : TVirtualPortV6;

begin
  F := Nil;
  H := LoadLibrary(VPAPIDLL);
  If H <> 0 Then
  Begin
    F := GetProcAddress(H,'SetVirtualPort');
    If Assigned(F) Then
    Begin
      FillChar(P,SizeOf(P),0);
      P.Size := SizeOf(TVirtualPortV6);
      P.PortName := StrNew(PChar(PortName.Text));
      P.Port := StrNew(PChar(Port.Text));
      If Not F(@P) Then
      Begin
        MessageDlg('SetVirtualPort() failed. ' + SysErrorMessage(GetLastError),mtError,[mbOK],0);
      End;
      FreeLibrary(H);
      StrDispose(P.PortName);
      StrDispose(P.Port);
    End Else
    Begin
      MessageDlg('GetProcAddress() failed. ' + SysErrorMessage(GetLastError),mtError,[mbOK],0);
    End;
  End Else
  Begin
    MessageDlg('LoadLibrary() failed. ' + SysErrorMessage(GetLastError),mtError,[mbOK],0);
  End;
end;


procedure TAPIForm.PortListChange(Sender: TObject);
begin
  PortName.Text := PortList.Text;
  If PortList.Items.Count > 0 Then
  Begin
    GetVPBtnClick(Self);
  End;
end;

end.
