﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Globalization;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Forms;
using VPM_API;
using SpoolUtil;

namespace VPM_API
{
    public partial class frmMain : Form
    {
        public frmMain()
        {
            InitializeComponent();
        }

        private void InitializePortList()
        {

            SpoolUtil.SpoolUtility.PORT_INFO_2[] PI2;
            PI2 = SpoolUtil.SpoolUtility.enumPorts();
            if (PI2.Length > 0)
            {
                for (int i = 0; i < PI2.Length; i++)
                {
                    if (PI2[i].pMonitorName == "Alphatronics Virtual Port")
                    {
                        cbPort.Items.Add(PI2[i].pPortName);
                    }
                }

            }
        }

        private void frmMain_Load(object sender, EventArgs e)
        {
            InitializePortList();

            for (int i = 0; i < Enum.GetNames(typeof(AVPMonitor.eFileHandlingOptions)).Length; i++)
            {
                cbFileHandling.Items.Add(Enum.GetNames(typeof(AVPMonitor.eFileHandlingOptions))[i].ToString());
            }
            for (int i = 0; i < Enum.GetNames(typeof(AVPMonitor.eUserDirOptions)).Length; i++)
            {
                cbUserDir.Items.Add(Enum.GetNames(typeof(AVPMonitor.eUserDirOptions))[i].ToString());
            }

            for (int i = 0; i < Enum.GetNames(typeof(AVPMonitor.eNameOptions)).Length; i++)
            {
                cbNameOptions.Items.Add(Enum.GetNames(typeof(AVPMonitor.eNameOptions))[i].ToString());
            }

            for (int i = 0; i < Enum.GetNames(typeof(AVPMonitor.eLogOptions)).Length; i++)
            {
                cbLogOptions.Items.Add(Enum.GetNames(typeof(AVPMonitor.eLogOptions))[i].ToString());
            }

            for (int i = 0; i < Enum.GetNames(typeof(AVPMonitor.eAppWaitOptions)).Length; i++)
            {
                cbAppWaitOptions.Items.Add(Enum.GetNames(typeof(AVPMonitor.eAppWaitOptions))[i].ToString());
            }

            cbDragDrop.Items.Add(bool.TrueString);
            cbDragDrop.Items.Add(bool.FalseString);
            cbDirectToFile.Items.Add(bool.TrueString);
            cbDirectToFile.Items.Add(bool.FalseString);
            cbAppWaitDelete.Items.Add(bool.TrueString);
            cbAppWaitDelete.Items.Add(bool.FalseString);

            for (int i = 0; i < Enum.GetNames(typeof(AVPMonitor.eTcpOptions)).Length; i++)
            {
                cbTCPOptions.Items.Add(Enum.GetNames(typeof(AVPMonitor.eTcpOptions))[i].ToString());
            }

            cbEnabled.Items.Add(bool.FalseString);
            cbEnabled.Items.Add(bool.TrueString);
            cbSnmpEnabled.Items.Add(bool.FalseString);
            cbSnmpEnabled.Items.Add(bool.TrueString);

            for (int i = 0; i < Enum.GetNames(typeof(AVPMonitor.eSnmpOptions)).Length; i++)
            {
                cbSnmpOptions.Items.Add(Enum.GetNames(typeof(AVPMonitor.eSnmpOptions))[i].ToString());
            }

            for (int i = 0; i < Enum.GetNames(typeof(AVPMonitor.eDebugOptions)).Length; i++)
            {
                cbDebugOptions.Items.Add(Enum.GetNames(typeof(AVPMonitor.eDebugOptions))[i].ToString());
            }

            for (int i = 0; i < Enum.GetNames(typeof(AVPMonitor.eTimeOptions)).Length; i++)
            {
                cbTimeOptions.Items.Add(Enum.GetNames(typeof(AVPMonitor.eTimeOptions))[i].ToString());
            }

        }


        private void btnSet_Click(object sender, EventArgs e)
        {
            if (cbPort.Text.Length == 0)
            {
                MessageBox.Show("Please select a port or enter a port name to create a new port","Error");
                return;
            }
            
            AVPMonitor VP = new AVPMonitor();
            VP.PortName = cbPort.Text;
            VP.OutputPath = tbPath.Text;
            VP.Application = tbApplication.Text;
            VP.DirectToFile = bool.Parse(cbDirectToFile.Text);
            VP.DragDrop = bool.Parse(cbDragDrop.Text);
            VP.Extension = tbExtension.Text;


            VP.FileHandlingOptions = (AVPMonitor.eFileHandlingOptions)Enum.Parse(typeof(AVPMonitor.eFileHandlingOptions), cbFileHandling.Text);
            VP.ForwardingPorts = tbForwarding.Text;
            VP.LogName = tbLogName.Text;
            VP.LogOptions = (AVPMonitor.eLogOptions)Enum.Parse(typeof(AVPMonitor.eLogOptions), cbLogOptions.Text);
            VP.NameOptions = (AVPMonitor.eNameOptions)Enum.Parse(typeof(AVPMonitor.eNameOptions), cbNameOptions.Text);
            VP.UserDir = (AVPMonitor.eUserDirOptions)Enum.Parse(typeof(AVPMonitor.eUserDirOptions), cbUserDir.Text); 
            VP.SpoolingList = tbSpooling.Text;
            VP.UserName = tbUserName.Text;
            VP.Password = tbPassword.Text;
            VP.Domain = tbDomain.Text;
            VP.AppWaitOptions = (AVPMonitor.eAppWaitOptions)Enum.Parse(typeof(AVPMonitor.eAppWaitOptions), cbAppWaitOptions.Text); 
            VP.AppWaitTimeout = int.Parse(tbAppWaitTimeout.Text);
            VP.AppWaitDelete = bool.Parse(cbAppWaitDelete.Text);

            VP.TCPPort = int.Parse(tbTCPPort.Text);
            VP.TCPBindings = tbTCPBindings.Text;
            VP.TCPOptions = (AVPMonitor.eTcpOptions)Enum.Parse(typeof(AVPMonitor.eTcpOptions), cbTCPOptions.Text);
            VP.Enabled = bool.Parse(cbEnabled.Text);
            VP.SnmpEnabled = bool.Parse(cbSnmpEnabled.Text);
            VP.SnmpManufacturer = tbSnmpManufacturer.Text;
            VP.SnmpHardwareId = tbSnmpHardwareId.Text;
            VP.SnmpModel = tbSnmpModel.Text;
            VP.SnmpOptions = (AVPMonitor.eSnmpOptions)Enum.Parse(typeof(AVPMonitor.eSnmpOptions), cbSnmpOptions.Text);
            VP.DebugOptions = (AVPMonitor.eDebugOptions)Enum.Parse(typeof(AVPMonitor.eDebugOptions), cbDebugOptions.Text);
            VP.TimeOptions = (AVPMonitor.eTimeOptions)Enum.Parse(typeof(AVPMonitor.eTimeOptions), cbTimeOptions.Text);
            VP.Modified = DateTime.Parse(tbModified.Text);
            VP.ModifiedBy = tbModifiedBy.Text;
            VP.ModifiedPreviously = DateTime.Parse(tbModifiedPreviously.Text);
            VP.ModifiedPreviouslyBy = tbModifiedPreviouslyBy.Text;

            if (!VP.SetVirtualPort())
            {
                string s = new Win32Exception(VP.LastWin32Error).Message;
                MessageBox.Show("Error: " + s, "Error");
            };

        }

        private void btnGet_Click(object sender, EventArgs e)
        {
            if (cbPort.Text.Length == 0)
            {
                MessageBox.Show("Please select a port", "Error");                
                return;
            }
            AVPMonitor VP = new AVPMonitor();
            if (VP.GetVirtualPort(cbPort.Text))
            {

                tbPath.Text = VP.OutputPath;
                tbApplication.Text = VP.Application;
                cbDirectToFile.Text = VP.DirectToFile.ToString();
                cbDragDrop.Text = VP.DragDrop.ToString();
                tbExtension.Text = VP.Extension;
                cbFileHandling.Text = VP.FileHandlingOptions.ToString();
                tbForwarding.Text = VP.ForwardingPorts;
                tbLogName.Text = VP.LogName;
                cbLogOptions.Text = VP.LogOptions.ToString();
                cbNameOptions.Text = VP.NameOptions.ToString();
                cbUserDir.Text = VP.UserDir.ToString();
                tbSpooling.Text = VP.SpoolingList;
                tbUserName.Text = VP.UserName;
                tbPassword.Text = VP.Password;
                tbDomain.Text = VP.Domain;
                cbAppWaitOptions.Text = VP.AppWaitOptions.ToString();
                tbAppWaitTimeout.Text = VP.AppWaitTimeout.ToString();
                cbAppWaitDelete.Text = VP.AppWaitDelete.ToString();
                tbTCPPort.Text = VP.TCPPort.ToString();
                tbTCPBindings.Text = VP.TCPBindings;
                cbTCPOptions.Text = VP.TCPOptions.ToString();
                cbEnabled.Text = VP.Enabled.ToString();
                cbSnmpEnabled.Text = VP.SnmpEnabled.ToString();
                tbSnmpManufacturer.Text = VP.SnmpManufacturer;
                tbSnmpHardwareId.Text = VP.SnmpHardwareId;
                tbSnmpModel.Text = VP.SnmpModel;
                cbSnmpOptions.Text = VP.SnmpOptions.ToString();
                cbDebugOptions.Text = VP.DebugOptions.ToString();
                cbTimeOptions.Text = VP.TimeOptions.ToString();
                tbModified.Text = VP.Modified == VP.InvalidDateTime ? "" : VP.Modified.ToString("g", DateTimeFormatInfo.CurrentInfo);
                tbModifiedBy.Text = VP.ModifiedBy;
                tbModifiedPreviously.Text = VP.ModifiedPreviously == VP.InvalidDateTime ? "" : VP.ModifiedPreviously.ToString("g", DateTimeFormatInfo.CurrentInfo);
                tbModifiedPreviouslyBy.Text = VP.ModifiedPreviouslyBy;

            }
            else 
            {
                string s  = new Win32Exception(VP.LastWin32Error).Message;
                MessageBox.Show("Error: " + s, "Error");
            }

        }
    }
}
