unit APIMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Winspool, AVPAPI;

type
  TAPIForm = class(TForm)
    SetVPBtn: TButton;
    PortName: TEdit;
    Application: TEdit;
    DirectToFile: TEdit;
    DragDrop: TEdit;
    Extension: TEdit;
    FileHandling: TEdit;
    Forwarding: TEdit;
    LogName: TEdit;
    LogOptions: TEdit;
    NameOptions: TEdit;
    Port: TEdit;
    ShowWindow: TEdit;
    UserDir: TEdit;
    Spooling: TEdit;
    UserName: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Password: TEdit;
    Domain: TEdit;
    ExitBtn: TButton;
    GetVPBtn: TButton;
    SetVPPathlBtn: TButton;
    Memo1: TMemo;
    PortList: TComboBox;
    Label18: TLabel;
    Label19: TLabel;
    AppWaitOptions: TEdit;
    AppWaitTimeout: TEdit;
    AppWaitDelete: TEdit;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    procedure SetVPBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ExitBtnClick(Sender: TObject);
    procedure GetVPBtnClick(Sender: TObject);
    procedure SetVPPathlBtnClick(Sender: TObject);
    procedure PortListChange(Sender: TObject);
  private
    { Private declarations }
    Procedure LoadPortList;
  public
    { Public declarations }
  end;

(* Type
  PVirtualPort32 = ^TVirtualPort;
  TVirtualPort32 = Record
    Size         : Cardinal;
    PortName     : PChar;
    Application  : PChar;
    DirectToFile : PChar;
    DragDrop     : PChar;
    Extension    : PChar;
    FileHandling : PChar;
    Forwarding   : PChar;
    LogName      : PChar;
    LogOptions   : PChar;
    NameOptions  : PChar;
    Port         : PChar;
    ShowWindow   : PChar;
    UserDir      : PChar;
    Spooling     : PChar;
    UserName     : PChar;
    Password     : PChar;
    Domain       : PChar;
  End;

  PVirtualPort = ^TVirtualPort;
  TVirtualPort = Packed Record
    Size           : Cardinal;
    PortName       : PChar;
    Application    : PChar;
    DirectToFile   : PChar;
    DragDrop       : PChar;
    Extension      : PChar;
    FileHandling   : PChar;
    Forwarding     : PChar;
    LogName        : PChar;
    LogOptions     : PChar;
    NameOptions    : PChar;
    Port           : PChar;
    ShowWindow     : PChar;
    UserDir        : PChar;
    Spooling       : PChar;
    UserName       : PChar;
    Password       : PChar;
    Domain         : PChar;
    AppWaitOptions : PChar;
    AppWaitTimeout : PChar;
    AppWaitDelete  : PChar;
  End; *)

  TSetVirtualPortProc = Function(VP : PVirtualPort) : LongBool; StdCall;
  TGetVirtualPortProc = Function(VP : PVirtualPort; BufferSize : Cardinal) : LongBool; StdCall;

var
  APIForm: TAPIForm;

implementation


{$R *.DFM}


Procedure ShowSystemError(UserMessage : String);
Var M : Array[0..512] of Char;
    E : Cardinal;
    S : String;
Begin
  E := GetLastError;
  FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM,Nil,E,0,@M,512,Nil);
  S := StrPas(M) + #13 + #10 + UserMessage + #13 + #10;
  MessageBox(0,PChar(S),PChar('System Error ' + IntToStr(E)),MB_OK or MB_ICONHAND or MB_TOPMOST or MB_SERVICE_NOTIFICATION);
End;

procedure TAPIForm.SetVPBtnClick(Sender: TObject);
Var H : THandle;
    F : TSetVirtualPortProc;
    P : TVirtualPort;

begin
  F := Nil;
  H := LoadLibrary(VPAPIDLL);
  If H <> 0 Then
    F := GetProcAddress(H,'SetVirtualPort');
  If Assigned(F) Then
  Begin
    FillChar(P,SizeOf(P),0);
    P.Size := SizeOf(TVirtualPort);
    P.hWnd := Handle;
    P.PortName := StrNew(PChar(PortName.Text));
    P.Application := StrNew(PChar(Application.Text));
    P.DirectToFile := StrNew(PChar(DirectToFile.Text));
    P.DragDrop := StrNew(PChar(DragDrop.Text));
    P.Extension := StrNew(PChar(Extension.Text));
    P.FileHandling := StrNew(PChar(FileHandling.Text));
    P.Forwarding := StrNew(PChar(Forwarding.Text));
    P.LogName := StrNew(PChar(LogName.Text));
    P.LogOptions := StrNew(PChar(LogOptions.Text));
    P.NameOptions := StrNew(PChar(NameOptions.Text));
    P.Port := StrNew(PChar(Port.Text));
    P.ShowWindow := StrNew(PChar(ShowWindow.Text));
    P.UserDir := StrNew(PChar(UserDir.Text));
    P.Spooling := StrNew(PChar(Spooling.Text));
    P.UserName := StrNew(PChar(UserName.Text));
    P.Password := StrNew(PChar(Password.Text));
    P.Domain := StrNew(PChar(Domain.Text));

    P.AppWaitOptions := StrNew(PChar(AppWaitOptions.Text));
    P.AppWaitTimeout := StrNew(PChar(AppWaitTimeout.Text));
    P.AppWaitDelete := StrNew(PChar(AppWaitDelete.Text));


    If Not F(@P) Then
      ShowSystemError('SetVirtualPort Failed') Else
        MessageBeep(MB_ICONEXCLAMATION);
    FreeLibrary(H);
    StrDispose(P.PortName);
    StrDispose(P.Application);
    StrDispose(P.DirectToFile);
    StrDispose(P.DragDrop);
    StrDispose(P.Extension);
    StrDispose(P.FileHandling);
    StrDispose(P.Forwarding);
    StrDispose(P.LogName);
    StrDispose(P.LogOptions);
    StrDispose(P.NameOptions);
    StrDispose(P.Port);
    StrDispose(P.ShowWindow);
    StrDispose(P.UserDir);
    StrDispose(P.Spooling);
    StrDispose(P.UserName);
    StrDispose(P.Password);
    StrDispose(P.Domain);

    StrDispose(P.AppWaitOptions);
    StrDispose(P.AppWaitTimeout);
    StrDispose(P.AppWaitDelete);
  End Else ShowSystemError('Library Failure');
end;

Procedure TAPIForm.LoadPortList;
Var I,N,R : Cardinal;
    P,M : PPortInfo2;
begin
  P := Nil;
  N := 0;
  R := 0;
  EnumPorts(Nil,2,P,0,N,R);
  If GetLastError = ERROR_INSUFFICIENT_BUFFER Then
  Begin
    GetMem(M,N);
    P := M;
    If EnumPorts(Nil,2,P,N,N,R) Then
    Begin
      For I := 0 to R - 1 Do
      Begin
        If StrComp(P^.pMonitorName,'Alphatronics Virtual Port') = 0 Then
        Begin
          PortList.Items.Add(StrPas(P^.pPortName));
        End;
        NativeUInt(P) := NativeUInt(P) + SizeOf(TPortInfo2);
      End;
      FreeMem(M);
      PortList.ItemIndex := 0;
    End;
  End;
End;

procedure TAPIForm.FormCreate(Sender: TObject);
begin
  If Win32Platform <> VER_PLATFORM_WIN32_NT Then
  Begin
    UserName.Enabled := False;
    Password.Enabled := False;
    Domain.Enabled := False;
  End;
  LoadPortList;
  If PortList.Items.Count > 0 Then
  Begin
    PortName.Text := PortList.Items[0];
    GetVPBtnClick(Self);
  End;
end;

procedure TAPIForm.ExitBtnClick(Sender: TObject);
begin
  Close;
end;

procedure TAPIForm.GetVPBtnClick(Sender: TObject);
Const BufferSize = 2048;
Var H : THandle;
    F : TGetVirtualPortProc;
    P : TVirtualPort;

begin
  F := Nil;
  H := LoadLibrary(VPAPIDLL);
  If H <> 0 Then
    F := GetProcAddress(H,'GetVirtualPort');
  If Assigned(F) Then
  Begin
    FillChar(P,SizeOf(P),0);
    P.Size := SizeOf(TVirtualPort);
    P.hWnd := Handle;
    P.PortName := StrAlloc(BufferSize);
    StrPCopy(P.PortName,PortName.Text);
    P.Application := StrAlloc(BufferSize);
    P.DirectToFile := StrAlloc(BufferSize);
    P.DragDrop := StrAlloc(BufferSize);
    P.Extension := StrAlloc(BufferSize);
    P.FileHandling := StrAlloc(BufferSize);
    P.Forwarding := StrAlloc(BufferSize);
    P.LogName := StrAlloc(BufferSize);
    P.LogOptions := StrAlloc(BufferSize);
    P.NameOptions := StrAlloc(BufferSize);
    P.Port := StrAlloc(BufferSize);
    P.ShowWindow := StrAlloc(BufferSize);
    P.UserDir := StrAlloc(BufferSize);
    P.Spooling := StrAlloc(BufferSize);
    P.UserName := StrAlloc(BufferSize);
    P.Password := StrAlloc(BufferSize);
    P.Domain := StrAlloc(BufferSize);

    P.AppWaitOptions := StrAlloc(BufferSize);
    P.AppWaitTimeout := StrAlloc(BufferSize);
    P.AppWaitDelete := StrAlloc(BufferSize);

    If Not F(@P,BufferSize) Then
      ShowSystemError('GetVirtualPort Failed') Else
    Begin
      PortName.Text := P.PortName;
      Application.Text := P.Application;
      DirectToFile.Text := P.DirectToFile;
      DragDrop.Text := P.DragDrop;
      Extension.Text := P.Extension;
      FileHandling.Text := P.FileHandling;
      Forwarding.Text := P.Forwarding;
      LogName.Text := P.LogName;
      LogOptions.Text := P.LogOptions;
      NameOptions.Text := P.NameOptions;
      Port.Text := P.Port;
      ShowWindow.Text := P.ShowWindow;
      UserDir.Text := P.UserDir;
      Spooling.Text := P.Spooling;
      UserName.Text := P.UserName;
      Password.Text := P.Password;
      Domain.Text := P.Domain;
      AppWaitOptions.Text := P.AppWaitOptions;
      AppWaittimeout.Text := P.AppWaitTimeout;
      AppWaitDelete.Text := P.AppWaitDelete;
    End;
    FreeLibrary(H);
    StrDispose(P.PortName);
    StrDispose(P.Application);
    StrDispose(P.DirectToFile);
    StrDispose(P.DragDrop);
    StrDispose(P.Extension);
    StrDispose(P.FileHandling);
    StrDispose(P.Forwarding);
    StrDispose(P.LogName);
    StrDispose(P.LogOptions);
    StrDispose(P.NameOptions);
    StrDispose(P.Port);
    StrDispose(P.ShowWindow);
    StrDispose(P.UserDir);
    StrDispose(P.Spooling);
    StrDispose(P.UserName);
    StrDispose(P.Password);
    StrDispose(P.Domain);

    StrDispose(P.AppWaitOptions);
    StrDispose(P.AppWaitTimeout);
    StrDispose(P.AppWaitDelete);
  End Else ShowSystemError('Library Failure');
end;

procedure TAPIForm.SetVPPathlBtnClick(Sender: TObject);
Var H : THandle;
    F : TSetVirtualPortProc;
    P : TVirtualPort;

begin
  F := Nil;
  H := LoadLibrary(VPAPIDLL);
  If H <> 0 Then
    F := GetProcAddress(H,'SetVirtualPort');
  If Assigned(F) Then
  Begin
    FillChar(P,SizeOf(P),0);
    P.Size := SizeOf(TVirtualPort);
    P.PortName := StrNew(PChar(PortName.Text));
    P.Port := StrNew(PChar(Port.Text));
    If Not F(@P) Then
      ShowSystemError('SetVirtualPort Failed');
    FreeLibrary(H);
    StrDispose(P.PortName);
    StrDispose(P.Port);
  End Else ShowSystemError('Library Failure');
end;


procedure TAPIForm.PortListChange(Sender: TObject);
begin
  PortName.Text := PortList.Text;
  If PortList.Items.Count > 0 Then GetVPBtnClick(Self);
end;

end.
