﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Forms;
using VPM_API;
using SpoolUtil;

namespace VPM_API
{
    public partial class frmMain : Form
    {
        public frmMain()
        {
            InitializeComponent();
        }

        private void InitializePortList()
        {

            SpoolUtil.SpoolUtility.PORT_INFO_2[] PI2;
            PI2 = SpoolUtil.SpoolUtility.enumPorts();
            if (PI2.Length > 0)
            {
                for (int i = 0; i < PI2.Length; i++)
                {
                    if (PI2[i].pMonitorName == "Alphatronics Virtual Port")
                    {
                        cbPort.Items.Add(PI2[i].pPortName);
                    }
                }

            }
        }

        private void frmMain_Load(object sender, EventArgs e)
        {
            InitializePortList();

            for (int i = 0; i < Enum.GetNames(typeof(AVPMonitor.eFileHandlingOptions)).Length; i++)
            {
                cbFileHandling.Items.Add(Enum.GetNames(typeof(AVPMonitor.eFileHandlingOptions))[i].ToString());
            }
            for (int i = 0; i < Enum.GetNames(typeof(AVPMonitor.eUserDirOptions)).Length; i++)
            {
                cbUserDir.Items.Add(Enum.GetNames(typeof(AVPMonitor.eUserDirOptions))[i].ToString());
            }

            for (int i = 0; i < Enum.GetNames(typeof(AVPMonitor.eNameOptions)).Length; i++)
            {
                cbNameOptions.Items.Add(Enum.GetNames(typeof(AVPMonitor.eNameOptions))[i].ToString());
            }

            for (int i = 0; i < Enum.GetNames(typeof(AVPMonitor.eLogOptions)).Length; i++)
            {
                cbLogOptions.Items.Add(Enum.GetNames(typeof(AVPMonitor.eLogOptions))[i].ToString());
            }

            for (int i = 0; i < Enum.GetNames(typeof(AVPMonitor.eAppWaitOptions)).Length; i++)
            {
                cbAppWaitOptions.Items.Add(Enum.GetNames(typeof(AVPMonitor.eAppWaitOptions))[i].ToString());
            }

            cbDragDrop.Items.Add(bool.TrueString);
            cbDragDrop.Items.Add(bool.FalseString);
            cbDirectToFile.Items.Add(bool.TrueString);
            cbDirectToFile.Items.Add(bool.FalseString);
            cbAppWaitDelete.Items.Add(bool.TrueString);
            cbAppWaitDelete.Items.Add(bool.FalseString);

        }

        private void btnSet_Click(object sender, EventArgs e)
        {
            if (cbPort.Text.Length == 0)
            {
                MessageBox.Show("Please select a port or enter a port name to create a new port","Error");
                return;
            }
            
            AVPMonitor VP = new AVPMonitor();
            VP.PortName = cbPort.Text;
            VP.OutputPath = tbPath.Text;
            VP.Application = tbApplication.Text;
            VP.DirectToFile = bool.Parse(cbDirectToFile.Text);
            VP.DragDrop = bool.Parse(cbDragDrop.Text);
            VP.Extension = tbExtension.Text;


            VP.FileHandlingOptions = (AVPMonitor.eFileHandlingOptions)Enum.Parse(typeof(AVPMonitor.eFileHandlingOptions), cbFileHandling.Text);
            VP.ForwardingPorts = tbForwarding.Text;
            VP.LogName = tbLogName.Text;
            VP.LogOptions = (AVPMonitor.eLogOptions)Enum.Parse(typeof(AVPMonitor.eLogOptions), cbLogOptions.Text);
            VP.NameOptions = (AVPMonitor.eNameOptions)Enum.Parse(typeof(AVPMonitor.eNameOptions), cbNameOptions.Text);
            VP.UserDir = (AVPMonitor.eUserDirOptions)Enum.Parse(typeof(AVPMonitor.eUserDirOptions), cbUserDir.Text); 
            VP.SpoolingList = tbSpooling.Text;
            VP.UserName = tbUserName.Text;
            VP.Password = tbPassword.Text;
            VP.Domain = tbDomain.Text;
            VP.AppWaitOptions = (AVPMonitor.eAppWaitOptions)Enum.Parse(typeof(AVPMonitor.eAppWaitOptions), cbAppWaitOptions.Text); 
            VP.AppWaitTimeout = int.Parse(tbAppWaitTimeout.Text);
            VP.AppWaitDelete = bool.Parse(cbAppWaitDelete.Text);
            if (!VP.SetVirtualPort(this.Handle))
            {
                MessageBox.Show("Error " + VP.LastWin32Error.ToString(), "Error");
            };

        }

        private void btnGet_Click(object sender, EventArgs e)
        {
            if (cbPort.Text.Length == 0)
            {
                MessageBox.Show("Please select a port", "Error");                
                return;
            }
            AVPMonitor VP = new AVPMonitor();
            if (VP.GetVirtualPort(cbPort.Text, this.Handle))
            {

                tbPath.Text = VP.OutputPath;
                tbApplication.Text = VP.Application;
                cbDirectToFile.Text = VP.DirectToFile.ToString();
                cbDragDrop.Text = VP.DragDrop.ToString();
                tbExtension.Text = VP.Extension;
                cbFileHandling.Text = VP.FileHandlingOptions.ToString();
                tbForwarding.Text = VP.ForwardingPorts;
                tbLogName.Text = VP.LogName;
                cbLogOptions.Text = VP.LogOptions.ToString();
                cbNameOptions.Text = VP.NameOptions.ToString();
                cbUserDir.Text = VP.UserDir.ToString();
                tbSpooling.Text = VP.SpoolingList;
                tbUserName.Text = VP.UserName;
                tbPassword.Text = VP.Password;
                tbDomain.Text = VP.Domain;
                cbAppWaitOptions.Text = VP.AppWaitOptions.ToString();
                tbAppWaitTimeout.Text = VP.AppWaitTimeout.ToString();
                cbAppWaitDelete.Text = VP.AppWaitDelete.ToString();
            }
            else 
            {
                MessageBox.Show("Error " + VP.LastWin32Error.ToString(), "Error");
            }

        }

    }
}
